/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.debugger;

import java.util.Vector;
import javax.swing.Action;
import org.apache.tools.ant.module.api.support.TargetLister;
import org.netbeans.modules.ant.debugger.AntDebugger;
import org.netbeans.modules.ant.debugger.Task;
import org.netbeans.modules.ant.debugger.Utils;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;

public class CallStackModel
implements TreeModel,
NodeModel,
NodeActionsProvider,
TableModel {
    public static final String CALL_STACK = "org/netbeans/modules/debugger/resources/callStackView/NonCurrentFrame";
    public static final String CURRENT_CALL_STACK = "org/netbeans/modules/debugger/resources/callStackView/CurrentFrame";
    private AntDebugger debugger;
    private Vector<ModelListener> listeners = new Vector();

    public CallStackModel(ContextProvider contextProvider) {
        this.debugger = (AntDebugger)((Object)contextProvider.lookupFirst(null, AntDebugger.class));
    }

    public Object getRoot() {
        return "Root";
    }

    public Object[] getChildren(Object parent, int from, int to) throws UnknownTypeException {
        if (parent == "Root") {
            return this.debugger.getCallStack();
        }
        throw new UnknownTypeException(parent);
    }

    public boolean isLeaf(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return false;
        }
        if (node instanceof TargetLister.Target) {
            return true;
        }
        if (node instanceof Task) {
            return true;
        }
        throw new UnknownTypeException(node);
    }

    public int getChildrenCount(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return this.debugger.getCallStack().length;
        }
        throw new UnknownTypeException(node);
    }

    public void addModelListener(ModelListener l) {
        this.listeners.add(l);
    }

    public void removeModelListener(ModelListener l) {
        this.listeners.remove(l);
    }

    public String getDisplayName(Object node) throws UnknownTypeException {
        if (node instanceof TargetLister.Target) {
            try {
                return ((TargetLister.Target)node).getName();
            }
            catch (IllegalStateException e) {
                return "";
            }
        }
        if (node instanceof Task) {
            try {
                return ((Task)node).getTaskStructure().getName();
            }
            catch (IllegalStateException e) {
                return "";
            }
        }
        if (node == "Root") {
            return "Root";
        }
        throw new UnknownTypeException(node);
    }

    public String getIconBase(Object node) throws UnknownTypeException {
        if (node instanceof TargetLister.Target) {
            return CALL_STACK;
        }
        if (node instanceof Task) {
            return CURRENT_CALL_STACK;
        }
        if (node == "Root") {
            return null;
        }
        throw new UnknownTypeException(node);
    }

    public String getShortDescription(Object node) throws UnknownTypeException {
        if (node instanceof TargetLister.Target) {
            return null;
        }
        if (node instanceof Task) {
            return null;
        }
        throw new UnknownTypeException(node);
    }

    public void performDefaultAction(Object node) throws UnknownTypeException {
        if (node instanceof TargetLister.Target) {
            Object line = Utils.getLine((TargetLister.Target)node, null);
            if (line != null) {
                Utils.showLine(line);
            }
            return;
        }
        if (node instanceof Task) {
            Object line = ((Task)node).getLine();
            if (line != null) {
                Utils.showLine(line);
            }
            return;
        }
        throw new UnknownTypeException(node);
    }

    public Action[] getActions(Object node) throws UnknownTypeException {
        return new Action[0];
    }

    public Object getValueAt(Object node, String columnID) throws UnknownTypeException {
        if (columnID == "CallStackFrameLocation") {
            if (node instanceof TargetLister.Target) {
                TargetLister.Target target = (TargetLister.Target)node;
                return target.getScript().getFile().getName() + ":" + Utils.getLineNumber(Utils.getLine((TargetLister.Target)node, null));
            }
            if (node instanceof Task) {
                Task task = (Task)node;
                return task.getFile().getName() + ":" + Utils.getLineNumber(task.getLine()) + "1";
            }
        }
        throw new UnknownTypeException(node);
    }

    public boolean isReadOnly(Object node, String columnID) throws UnknownTypeException {
        if (columnID == "CallStackFrameLocation") {
            if (node instanceof TargetLister.Target) {
                return true;
            }
            if (node instanceof Task) {
                return true;
            }
        }
        throw new UnknownTypeException(node);
    }

    public void setValueAt(Object node, String columnID, Object value) throws UnknownTypeException {
        throw new UnknownTypeException(node);
    }

    void fireChanges() {
        Vector<ModelListener> v = new Vector<ModelListener>(this.listeners);
        int k = v.size();
        for (int i = 0; i < k; ++i) {
            v.get(i).modelChanged((ModelEvent)new ModelEvent.TreeChanged((Object)this));
        }
    }
}

